//
//  BPCloudSignUpDetails.h
//  BIViews
//
//  Created by Brent Gulanowski on 11-01-26.
//  Copyright 2011 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import <BPViews/BPViewController.h>

@class BPCloudIDFormatter;
@class MCRestRequest, MCClickableTextField;

@interface BPCloudSignUpDetails : BPViewController<NSTextFieldDelegate> {
	
	MCRestRequest *checkCloudIDRequest;
	
	MCClickableTextField *showTermsField;
	IBOutlet MCClickableTextField *showPlansField;

    IBOutlet BPCloudIDFormatter * cloudIDFormatter;
    
	IBOutlet NSTextField *cloudIDField;
	IBOutlet NSTextField *passwordField;
	IBOutlet NSTextField *verifyPWField;
	IBOutlet NSTextField *emailField;
	IBOutlet NSTextField *contactField;
	
	IBOutlet NSArrayController *countriesAC;
	
	NSArray *countries;
	NSDictionary *country;
	
	NSString *company;
	NSString *cloudID;
	NSString *firstName;
	NSString *lastName;
	NSString *password;
	NSString *verifyPW;	
	NSString *email;
	NSString *phone;
	NSString *contactEmail;
	
	NSString *passwordErrorMessage;
	
	NSUInteger usersCount;
	NSUInteger contactMethod;
	NSUInteger suggestionCount;
	BOOL contact;
	BOOL agreeToTerms;
	
	BOOL cloudIDAvailable;
	BOOL allowSuggestions;

	BOOL cloudIDValid;
	BOOL passwordValid;
	BOOL emailValid;
	
	BOOL companyMissing;
	BOOL cloudIDMissing;
	BOOL firstNameMissing;
	BOOL lastNameMissing;
	BOOL passwordMissing;
	BOOL verifyPWMissing;
	BOOL countryMissing;
	BOOL emailMissing;
	BOOL phoneMissing;
	BOOL agreeMissing;
}

@property (nonatomic, retain) MCRestRequest *checkCloudIDRequest;
@property (nonatomic, assign) IBOutlet MCClickableTextField *showTermsField;

@property (nonatomic, retain) NSArray *countries;
@property (nonatomic, retain) NSDictionary *country;

@property (nonatomic, copy) NSString *company;
@property (nonatomic, copy) NSString *cloudID;
@property (nonatomic, copy) NSString *firstName;
@property (nonatomic, copy) NSString *lastName;
@property (nonatomic, copy) NSString *password;
@property (nonatomic, copy) NSString *verifyPW;	
@property (nonatomic, copy) NSString *email;
@property (nonatomic, copy) NSString *phone;
@property (nonatomic, copy) NSString *contactEmail;
@property (nonatomic, readonly) NSString *prospectiveProfileId;

@property (readonly) NSString *cloudIDErrorMessage;
@property (nonatomic, copy) NSString *passwordErrorMessage;

@property (nonatomic) NSUInteger usersCount;
@property (nonatomic) NSUInteger contactMethod;

@property (nonatomic) BOOL contact;
@property (nonatomic) BOOL agreeToTerms;

// A valid cloudID is longer than 0 characters and unique (determined by querying the cloud)
@property (nonatomic) BOOL cloudIDAvailable;
@property (nonatomic) BOOL cloudIDValid;
@property (nonatomic) BOOL passwordValid;
@property (nonatomic) BOOL emailValid;

@property (nonatomic) BOOL companyMissing;
@property (nonatomic) BOOL cloudIDMissing;
@property (nonatomic) BOOL firstNameMissing;
@property (nonatomic) BOOL lastNameMissing;
@property (nonatomic) BOOL passwordMissing;
@property (nonatomic) BOOL verifyPWMissing;
@property (nonatomic) BOOL countryMissing;
@property (nonatomic) BOOL emailMissing;
@property (nonatomic) BOOL phoneMissing;
@property (nonatomic) BOOL agreeMissing;

@property (readonly) BOOL passwordVerified;
@property (readonly) BOOL phoneValid;
@property (readonly) NSDictionary *accountSetUpDetails;

@property (readonly) NSColor *optionalTextColor;
@property (readonly) NSString *contactLabel;


- (void)verifyPassword;
- (void)validateCloudID;
- (void)suggestCloudID;
- (BOOL)requirementsMet;
- (void)reset;

- (IBAction)suggestCloudID:(id)sender;
- (IBAction)showPlans:(id)sender;

- (IBAction)checkForEmptySelectionCountry:(id)sender;
- (IBAction)checkForEmptyStringPhone:(id)sender;

+ (void)initCountries; // called from +initialize

@end
